-- Show the health of a player as a small piece of colored text above their head
-- A 3Ra Gaming creation

local function showhealth (event)
	if game.tick % 30 ~= 0 then return end
	for k, player in pairs(game.players) do
		if player.connected then
			if player.character then
				if player.character.health == nil then return end
				local index = player.index
				local health = math.ceil(player.character.health)
				if global.player_health == nil then global.player_health = {} end
				if global.player_health[index] == nil then global.player_health[index] = health end
				if global.player_health[index] ~= health then
					global.player_health[index] = health
					if health < 151 then
						if health > 99 then
							player.surface.create_entity { name = "flying-text", color = { b = 0.2, r = 0.1, g = 1, a = 0.8 }, text = (health), position = { player.position.x, player.position.y - 2 } }
						elseif health > 49 then
							player.surface.create_entity { name = "flying-text", color = { r = 1, g = 1, b = 0 }, text = (health), position = { player.position.x, player.position.y - 2 } }
						else
							player.surface.create_entity { name = "flying-text", color = { b = 0.1, r = 1, g = 0, a = 0.8 }, text = (health), position = { player.position.x, player.position.y - 2 } }
						end
					end
				end
			end
		end
	end
end


Event.register(defines.events.on_tick, showhealth)